/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code93Reader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Map;

public class Code93Writer
extends OneDimensionalCodeWriter {
    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) throws WriterException {
        if (format != BarcodeFormat.CODE_93) {
            throw new IllegalArgumentException("Can only encode CODE_93, but got " + (Object)((Object)format));
        }
        return super.encode(contents, format, width, height, hints);
    }

    @Override
    public boolean[] encode(String contents) {
        int length = (contents = Code93Writer.convertToExtended(contents)).length();
        if (length > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long after converting to extended encoding, but got " + length);
        }
        int codeWidth = (contents.length() + 2 + 2) * 9 + 1;
        boolean[] result = new boolean[codeWidth];
        int pos = Code93Writer.appendPattern(result, 0, Code93Reader.ASTERISK_ENCODING);
        int i = 0;
        while (i < length) {
            int indexInString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(contents.charAt(i));
            pos += Code93Writer.appendPattern(result, pos, Code93Reader.CHARACTER_ENCODINGS[indexInString]);
            ++i;
        }
        int check1 = Code93Writer.computeChecksumIndex(contents, 20);
        pos += Code93Writer.appendPattern(result, pos, Code93Reader.CHARACTER_ENCODINGS[check1]);
        contents = String.valueOf(contents) + "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".charAt(check1);
        int check2 = Code93Writer.computeChecksumIndex(contents, 15);
        pos += Code93Writer.appendPattern(result, pos, Code93Reader.CHARACTER_ENCODINGS[check2]);
        pos += Code93Writer.appendPattern(result, pos, Code93Reader.ASTERISK_ENCODING);
        result[pos] = true;
        return result;
    }

    @Deprecated
    protected static int appendPattern(boolean[] target, int pos, int[] pattern, boolean startColor) {
        int[] nArray = pattern;
        int n = pattern.length;
        int n2 = 0;
        while (n2 < n) {
            int bit = nArray[n2];
            target[pos++] = bit != 0;
            ++n2;
        }
        return 9;
    }

    private static int appendPattern(boolean[] target, int pos, int a) {
        int i = 0;
        while (i < 9) {
            int temp = a & 1 << 8 - i;
            target[pos + i] = temp != 0;
            ++i;
        }
        return 9;
    }

    private static int computeChecksumIndex(String contents, int maxWeight) {
        int weight = 1;
        int total = 0;
        int i = contents.length() - 1;
        while (i >= 0) {
            int indexInString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(contents.charAt(i));
            total += indexInString * weight;
            if (++weight > maxWeight) {
                weight = 1;
            }
            --i;
        }
        return total % 47;
    }

    static String convertToExtended(String contents) {
        int length = contents.length();
        StringBuilder extendedContent = new StringBuilder(length * 2);
        int i = 0;
        while (i < length) {
            char character = contents.charAt(i);
            if (character == '\u0000') {
                extendedContent.append("bU");
            } else if (character <= '\u001a') {
                extendedContent.append('a');
                extendedContent.append((char)(65 + character - 1));
            } else if (character <= '\u001f') {
                extendedContent.append('b');
                extendedContent.append((char)(65 + character - 27));
            } else if (character == ' ' || character == '$' || character == '%' || character == '+') {
                extendedContent.append(character);
            } else if (character <= ',') {
                extendedContent.append('c');
                extendedContent.append((char)(65 + character - 33));
            } else if (character <= '9') {
                extendedContent.append(character);
            } else if (character == ':') {
                extendedContent.append("cZ");
            } else if (character <= '?') {
                extendedContent.append('b');
                extendedContent.append((char)(70 + character - 59));
            } else if (character == '@') {
                extendedContent.append("bV");
            } else if (character <= 'Z') {
                extendedContent.append(character);
            } else if (character <= '_') {
                extendedContent.append('b');
                extendedContent.append((char)(75 + character - 91));
            } else if (character == '`') {
                extendedContent.append("bW");
            } else if (character <= 'z') {
                extendedContent.append('d');
                extendedContent.append((char)(65 + character - 97));
            } else if (character <= '\u007f') {
                extendedContent.append('b');
                extendedContent.append((char)(80 + character - 123));
            } else {
                throw new IllegalArgumentException("Requested content contains a non-encodable character: '" + character + "'");
            }
            ++i;
        }
        return extendedContent.toString();
    }
}

