/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class SimpleImages {
    public static void main(String[] args) throws Exception {
        XWPFDocument doc = new XWPFDocument();
        XWPFParagraph p = doc.createParagraph();
        XWPFRun r = p.createRun();
        for (String imgFile : args) {
            int format;
            if (imgFile.endsWith(".emf")) {
                format = 2;
            } else if (imgFile.endsWith(".wmf")) {
                format = 3;
            } else if (imgFile.endsWith(".pict")) {
                format = 4;
            } else if (imgFile.endsWith(".jpeg") || imgFile.endsWith(".jpg")) {
                format = 5;
            } else if (imgFile.endsWith(".png")) {
                format = 6;
            } else if (imgFile.endsWith(".dib")) {
                format = 7;
            } else if (imgFile.endsWith(".gif")) {
                format = 8;
            } else if (imgFile.endsWith(".tiff")) {
                format = 9;
            } else if (imgFile.endsWith(".eps")) {
                format = 10;
            } else if (imgFile.endsWith(".bmp")) {
                format = 11;
            } else if (imgFile.endsWith(".wpg")) {
                format = 12;
            } else {
                System.err.println("Unsupported picture: " + imgFile + ". Expected emf|wmf|pict|jpeg|png|dib|gif|tiff|eps|bmp|wpg");
                continue;
            }
            r.setText(imgFile);
            r.addBreak();
            r.addPicture((InputStream)new FileInputStream(imgFile), format, imgFile, Units.toEMU((double)200.0), Units.toEMU((double)200.0));
            r.addBreak(BreakType.PAGE);
        }
        FileOutputStream out = new FileOutputStream("images.docx");
        doc.write((OutputStream)out);
        out.close();
    }
}

