/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.poibrowser;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.poibrowser.DocumentDescriptor;
import org.apache.poi.poifs.poibrowser.DocumentDescriptorRenderer;
import org.apache.poi.poifs.poibrowser.ExtendableTreeCellRenderer;
import org.apache.poi.poifs.poibrowser.PropertySetDescriptor;
import org.apache.poi.poifs.poibrowser.PropertySetDescriptorRenderer;
import org.apache.poi.poifs.poibrowser.TreeReaderListener;

public class POIBrowser
extends JFrame {
    protected MutableTreeNode rootNode;

    public static void main(String[] args) {
        new POIBrowser().run(args);
    }

    protected void run(String[] args) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.rootNode = new DefaultMutableTreeNode("POI Filesystems");
        DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
        JTree treeUI = new JTree(treeModel);
        this.getContentPane().add(new JScrollPane(treeUI));
        int displayedFiles = 0;
        for (int i = 0; i < args.length; ++i) {
            String filename = args[i];
            try {
                POIFSReader r = new POIFSReader();
                r.registerListener((POIFSReaderListener)new TreeReaderListener(filename, this.rootNode));
                r.read((InputStream)new FileInputStream(filename));
                ++displayedFiles;
                continue;
            }
            catch (IOException ex) {
                System.err.println(filename + ": " + ex);
                continue;
            }
            catch (Exception t) {
                System.err.println("Unexpected exception while reading \"" + filename + "\":");
                t.printStackTrace(System.err);
            }
        }
        if (displayedFiles == 0) {
            System.out.println("No POI filesystem(s) to display.");
            System.exit(0);
        }
        treeUI.setRootVisible(true);
        treeUI.setShowsRootHandles(true);
        ExtendableTreeCellRenderer etcr = new ExtendableTreeCellRenderer();
        etcr.register(DocumentDescriptor.class, new DocumentDescriptorRenderer());
        etcr.register(PropertySetDescriptor.class, new PropertySetDescriptorRenderer());
        treeUI.setCellRenderer(etcr);
        this.setSize(600, 450);
        this.setTitle("POI Browser 0.09");
        this.setVisible(true);
    }
}

