/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.detector.MathUtils;
import com.google.zxing.pdf417.PDF417Common;
import com.google.zxing.pdf417.decoder.BarcodeMetadata;
import com.google.zxing.pdf417.decoder.BarcodeValue;
import com.google.zxing.pdf417.decoder.BoundingBox;
import com.google.zxing.pdf417.decoder.Codeword;
import com.google.zxing.pdf417.decoder.DecodedBitStreamParser;
import com.google.zxing.pdf417.decoder.DetectionResult;
import com.google.zxing.pdf417.decoder.DetectionResultColumn;
import com.google.zxing.pdf417.decoder.DetectionResultRowIndicatorColumn;
import com.google.zxing.pdf417.decoder.PDF417CodewordDecoder;
import com.google.zxing.pdf417.decoder.ec.ErrorCorrection;
import java.util.ArrayList;
import java.util.Formatter;

public final class PDF417ScanningDecoder {
    private static final int CODEWORD_SKEW_SIZE = 2;
    private static final int MAX_ERRORS = 3;
    private static final int MAX_EC_CODEWORDS = 512;
    private static final ErrorCorrection errorCorrection = new ErrorCorrection();

    private PDF417ScanningDecoder() {
    }

    public static DecoderResult decode(BitMatrix image, ResultPoint imageTopLeft, ResultPoint imageBottomLeft, ResultPoint imageTopRight, ResultPoint imageBottomRight, int minCodewordWidth, int maxCodewordWidth) throws NotFoundException, FormatException, ChecksumException {
        DetectionResult detectionResult;
        BoundingBox boundingBox = new BoundingBox(image, imageTopLeft, imageBottomLeft, imageTopRight, imageBottomRight);
        DetectionResultRowIndicatorColumn leftRowIndicatorColumn = null;
        DetectionResultRowIndicatorColumn rightRowIndicatorColumn = null;
        boolean firstPass = true;
        while (true) {
            if (imageTopLeft != null) {
                leftRowIndicatorColumn = PDF417ScanningDecoder.getRowIndicatorColumn(image, boundingBox, imageTopLeft, true, minCodewordWidth, maxCodewordWidth);
            }
            if (imageTopRight != null) {
                rightRowIndicatorColumn = PDF417ScanningDecoder.getRowIndicatorColumn(image, boundingBox, imageTopRight, false, minCodewordWidth, maxCodewordWidth);
            }
            if ((detectionResult = PDF417ScanningDecoder.merge(leftRowIndicatorColumn, rightRowIndicatorColumn)) == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            BoundingBox resultBox = detectionResult.getBoundingBox();
            if (!firstPass || resultBox == null || resultBox.getMinY() >= boundingBox.getMinY() && resultBox.getMaxY() <= boundingBox.getMaxY()) break;
            boundingBox = resultBox;
            firstPass = false;
        }
        detectionResult.setBoundingBox(boundingBox);
        int maxBarcodeColumn = detectionResult.getBarcodeColumnCount() + 1;
        detectionResult.setDetectionResultColumn(0, leftRowIndicatorColumn);
        detectionResult.setDetectionResultColumn(maxBarcodeColumn, rightRowIndicatorColumn);
        boolean leftToRight = leftRowIndicatorColumn != null;
        int barcodeColumnCount = 1;
        while (barcodeColumnCount <= maxBarcodeColumn) {
            block10: {
                int startColumn;
                int barcodeColumn;
                int n = barcodeColumn = leftToRight ? barcodeColumnCount : maxBarcodeColumn - barcodeColumnCount;
                if (detectionResult.getDetectionResultColumn(barcodeColumn) != null) break block10;
                DetectionResultColumn detectionResultColumn = barcodeColumn == 0 || barcodeColumn == maxBarcodeColumn ? new DetectionResultRowIndicatorColumn(boundingBox, barcodeColumn == 0) : new DetectionResultColumn(boundingBox);
                detectionResult.setDetectionResultColumn(barcodeColumn, detectionResultColumn);
                int previousStartColumn = startColumn = -1;
                int imageRow = boundingBox.getMinY();
                while (imageRow <= boundingBox.getMaxY()) {
                    block12: {
                        Codeword codeword;
                        block11: {
                            startColumn = PDF417ScanningDecoder.getStartColumn(detectionResult, barcodeColumn, imageRow, leftToRight);
                            if (startColumn >= 0 && startColumn <= boundingBox.getMaxX()) break block11;
                            if (previousStartColumn == -1) break block12;
                            startColumn = previousStartColumn;
                        }
                        if ((codeword = PDF417ScanningDecoder.detectCodeword(image, boundingBox.getMinX(), boundingBox.getMaxX(), leftToRight, startColumn, imageRow, minCodewordWidth, maxCodewordWidth)) != null) {
                            detectionResultColumn.setCodeword(imageRow, codeword);
                            previousStartColumn = startColumn;
                            minCodewordWidth = Math.min(minCodewordWidth, codeword.getWidth());
                            maxCodewordWidth = Math.max(maxCodewordWidth, codeword.getWidth());
                        }
                    }
                    ++imageRow;
                }
            }
            ++barcodeColumnCount;
        }
        return PDF417ScanningDecoder.createDecoderResult(detectionResult);
    }

    private static DetectionResult merge(DetectionResultRowIndicatorColumn leftRowIndicatorColumn, DetectionResultRowIndicatorColumn rightRowIndicatorColumn) throws NotFoundException {
        if (leftRowIndicatorColumn == null && rightRowIndicatorColumn == null) {
            return null;
        }
        BarcodeMetadata barcodeMetadata = PDF417ScanningDecoder.getBarcodeMetadata(leftRowIndicatorColumn, rightRowIndicatorColumn);
        if (barcodeMetadata == null) {
            return null;
        }
        BoundingBox boundingBox = BoundingBox.merge(PDF417ScanningDecoder.adjustBoundingBox(leftRowIndicatorColumn), PDF417ScanningDecoder.adjustBoundingBox(rightRowIndicatorColumn));
        return new DetectionResult(barcodeMetadata, boundingBox);
    }

    private static BoundingBox adjustBoundingBox(DetectionResultRowIndicatorColumn rowIndicatorColumn) throws NotFoundException {
        if (rowIndicatorColumn == null) {
            return null;
        }
        int[] rowHeights = rowIndicatorColumn.getRowHeights();
        if (rowHeights == null) {
            return null;
        }
        int maxRowHeight = PDF417ScanningDecoder.getMax(rowHeights);
        int missingStartRows = 0;
        int[] nArray = rowHeights;
        int n = rowHeights.length;
        int n2 = 0;
        while (n2 < n) {
            int rowHeight = nArray[n2];
            missingStartRows += maxRowHeight - rowHeight;
            if (rowHeight > 0) break;
            ++n2;
        }
        Codeword[] codewords = rowIndicatorColumn.getCodewords();
        int row = 0;
        while (missingStartRows > 0 && codewords[row] == null) {
            --missingStartRows;
            ++row;
        }
        int missingEndRows = 0;
        int row2 = rowHeights.length - 1;
        while (row2 >= 0) {
            missingEndRows += maxRowHeight - rowHeights[row2];
            if (rowHeights[row2] > 0) break;
            --row2;
        }
        row2 = codewords.length - 1;
        while (missingEndRows > 0 && codewords[row2] == null) {
            --missingEndRows;
            --row2;
        }
        return rowIndicatorColumn.getBoundingBox().addMissingRows(missingStartRows, missingEndRows, rowIndicatorColumn.isLeft());
    }

    private static int getMax(int[] values) {
        int maxValue = -1;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            maxValue = Math.max(maxValue, value);
            ++n2;
        }
        return maxValue;
    }

    private static BarcodeMetadata getBarcodeMetadata(DetectionResultRowIndicatorColumn leftRowIndicatorColumn, DetectionResultRowIndicatorColumn rightRowIndicatorColumn) {
        BarcodeMetadata rightBarcodeMetadata;
        BarcodeMetadata leftBarcodeMetadata;
        if (leftRowIndicatorColumn == null || (leftBarcodeMetadata = leftRowIndicatorColumn.getBarcodeMetadata()) == null) {
            return rightRowIndicatorColumn == null ? null : rightRowIndicatorColumn.getBarcodeMetadata();
        }
        if (rightRowIndicatorColumn == null || (rightBarcodeMetadata = rightRowIndicatorColumn.getBarcodeMetadata()) == null) {
            return leftBarcodeMetadata;
        }
        if (leftBarcodeMetadata.getColumnCount() != rightBarcodeMetadata.getColumnCount() && leftBarcodeMetadata.getErrorCorrectionLevel() != rightBarcodeMetadata.getErrorCorrectionLevel() && leftBarcodeMetadata.getRowCount() != rightBarcodeMetadata.getRowCount()) {
            return null;
        }
        return leftBarcodeMetadata;
    }

    private static DetectionResultRowIndicatorColumn getRowIndicatorColumn(BitMatrix image, BoundingBox boundingBox, ResultPoint startPoint, boolean leftToRight, int minCodewordWidth, int maxCodewordWidth) {
        DetectionResultRowIndicatorColumn rowIndicatorColumn = new DetectionResultRowIndicatorColumn(boundingBox, leftToRight);
        int i = 0;
        while (i < 2) {
            int increment = i == 0 ? 1 : -1;
            int startColumn = (int)startPoint.getX();
            int imageRow = (int)startPoint.getY();
            while (imageRow <= boundingBox.getMaxY() && imageRow >= boundingBox.getMinY()) {
                Codeword codeword = PDF417ScanningDecoder.detectCodeword(image, 0, image.getWidth(), leftToRight, startColumn, imageRow, minCodewordWidth, maxCodewordWidth);
                if (codeword != null) {
                    rowIndicatorColumn.setCodeword(imageRow, codeword);
                    startColumn = leftToRight ? codeword.getStartX() : codeword.getEndX();
                }
                imageRow += increment;
            }
            ++i;
        }
        return rowIndicatorColumn;
    }

    private static void adjustCodewordCount(DetectionResult detectionResult, BarcodeValue[][] barcodeMatrix) throws NotFoundException {
        BarcodeValue barcodeMatrix01 = barcodeMatrix[0][1];
        int[] numberOfCodewords = barcodeMatrix01.getValue();
        int calculatedNumberOfCodewords = detectionResult.getBarcodeColumnCount() * detectionResult.getBarcodeRowCount() - PDF417ScanningDecoder.getNumberOfECCodeWords(detectionResult.getBarcodeECLevel());
        if (numberOfCodewords.length == 0) {
            if (calculatedNumberOfCodewords < 1 || calculatedNumberOfCodewords > 928) {
                throw NotFoundException.getNotFoundInstance();
            }
            barcodeMatrix01.setValue(calculatedNumberOfCodewords);
        } else if (numberOfCodewords[0] != calculatedNumberOfCodewords) {
            barcodeMatrix01.setValue(calculatedNumberOfCodewords);
        }
    }

    private static DecoderResult createDecoderResult(DetectionResult detectionResult) throws FormatException, ChecksumException, NotFoundException {
        BarcodeValue[][] barcodeMatrix = PDF417ScanningDecoder.createBarcodeMatrix(detectionResult);
        PDF417ScanningDecoder.adjustCodewordCount(detectionResult, barcodeMatrix);
        ArrayList<Integer> erasures = new ArrayList<Integer>();
        int[] codewords = new int[detectionResult.getBarcodeRowCount() * detectionResult.getBarcodeColumnCount()];
        ArrayList<int[]> ambiguousIndexValuesList = new ArrayList<int[]>();
        ArrayList<Integer> ambiguousIndexesList = new ArrayList<Integer>();
        int row = 0;
        while (row < detectionResult.getBarcodeRowCount()) {
            int column = 0;
            while (column < detectionResult.getBarcodeColumnCount()) {
                int[] values = barcodeMatrix[row][column + 1].getValue();
                int codewordIndex = row * detectionResult.getBarcodeColumnCount() + column;
                if (values.length == 0) {
                    erasures.add(codewordIndex);
                } else if (values.length == 1) {
                    codewords[codewordIndex] = values[0];
                } else {
                    ambiguousIndexesList.add(codewordIndex);
                    ambiguousIndexValuesList.add(values);
                }
                ++column;
            }
            ++row;
        }
        int[][] ambiguousIndexValues = new int[ambiguousIndexValuesList.size()][];
        int i = 0;
        while (i < ambiguousIndexValues.length) {
            ambiguousIndexValues[i] = (int[])ambiguousIndexValuesList.get(i);
            ++i;
        }
        return PDF417ScanningDecoder.createDecoderResultFromAmbiguousValues(detectionResult.getBarcodeECLevel(), codewords, PDF417Common.toIntArray(erasures), PDF417Common.toIntArray(ambiguousIndexesList), ambiguousIndexValues);
    }

    /*
     * Unable to fully structure code
     */
    private static DecoderResult createDecoderResultFromAmbiguousValues(int ecLevel, int[] codewords, int[] erasureArray, int[] ambiguousIndexes, int[][] ambiguousIndexValues) throws FormatException, ChecksumException {
        ambiguousIndexCount = new int[ambiguousIndexes.length];
        tries = 100;
        block2: while (tries-- > 0) {
            i = 0;
            while (i < ambiguousIndexCount.length) {
                codewords[ambiguousIndexes[i]] = ambiguousIndexValues[i][ambiguousIndexCount[i]];
                ++i;
            }
            try {
                return PDF417ScanningDecoder.decodeCodewords(codewords, ecLevel, erasureArray);
            }
            catch (ChecksumException i) {
                if (ambiguousIndexCount.length == 0) {
                    throw ChecksumException.getChecksumInstance();
                }
                i = 0;
                ** while (i < ambiguousIndexCount.length)
            }
lbl-1000:
            // 1 sources

            {
                if (ambiguousIndexCount[i] < ambiguousIndexValues[i].length - 1) {
                    v0 = i;
                    ambiguousIndexCount[v0] = ambiguousIndexCount[v0] + 1;
                    continue block2;
                }
                ambiguousIndexCount[i] = 0;
                if (i == ambiguousIndexCount.length - 1) {
                    throw ChecksumException.getChecksumInstance();
                }
                ++i;
                continue;
lbl25:
                // 1 sources

            }
        }
        throw ChecksumException.getChecksumInstance();
    }

    private static BarcodeValue[][] createBarcodeMatrix(DetectionResult detectionResult) {
        BarcodeValue[][] barcodeMatrix = new BarcodeValue[detectionResult.getBarcodeRowCount()][detectionResult.getBarcodeColumnCount() + 2];
        int row = 0;
        while (row < barcodeMatrix.length) {
            int column = 0;
            while (column < barcodeMatrix[row].length) {
                barcodeMatrix[row][column] = new BarcodeValue();
                ++column;
            }
            ++row;
        }
        int column = 0;
        DetectionResultColumn[] detectionResultColumnArray = detectionResult.getDetectionResultColumns();
        int n = detectionResultColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            DetectionResultColumn detectionResultColumn = detectionResultColumnArray[n2];
            if (detectionResultColumn != null) {
                Codeword[] codewordArray = detectionResultColumn.getCodewords();
                int n3 = codewordArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int rowNumber;
                    Codeword codeword = codewordArray[n4];
                    if (codeword != null && (rowNumber = codeword.getRowNumber()) >= 0 && rowNumber < barcodeMatrix.length) {
                        barcodeMatrix[rowNumber][column].setValue(codeword.getValue());
                    }
                    ++n4;
                }
            }
            ++column;
            ++n2;
        }
        return barcodeMatrix;
    }

    private static boolean isValidBarcodeColumn(DetectionResult detectionResult, int barcodeColumn) {
        return barcodeColumn >= 0 && barcodeColumn <= detectionResult.getBarcodeColumnCount() + 1;
    }

    private static int getStartColumn(DetectionResult detectionResult, int barcodeColumn, int imageRow, boolean leftToRight) {
        int offset = leftToRight ? 1 : -1;
        Codeword codeword = null;
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, barcodeColumn - offset)) {
            codeword = detectionResult.getDetectionResultColumn(barcodeColumn - offset).getCodeword(imageRow);
        }
        if (codeword != null) {
            return leftToRight ? codeword.getEndX() : codeword.getStartX();
        }
        codeword = detectionResult.getDetectionResultColumn(barcodeColumn).getCodewordNearby(imageRow);
        if (codeword != null) {
            return leftToRight ? codeword.getStartX() : codeword.getEndX();
        }
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, barcodeColumn - offset)) {
            codeword = detectionResult.getDetectionResultColumn(barcodeColumn - offset).getCodewordNearby(imageRow);
        }
        if (codeword != null) {
            return leftToRight ? codeword.getEndX() : codeword.getStartX();
        }
        int skippedColumns = 0;
        while (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, barcodeColumn - offset)) {
            Codeword[] codewordArray = detectionResult.getDetectionResultColumn(barcodeColumn -= offset).getCodewords();
            int n = codewordArray.length;
            int n2 = 0;
            while (n2 < n) {
                Codeword previousRowCodeword = codewordArray[n2];
                if (previousRowCodeword != null) {
                    return (leftToRight ? previousRowCodeword.getEndX() : previousRowCodeword.getStartX()) + offset * skippedColumns * (previousRowCodeword.getEndX() - previousRowCodeword.getStartX());
                }
                ++n2;
            }
            ++skippedColumns;
        }
        return leftToRight ? detectionResult.getBoundingBox().getMinX() : detectionResult.getBoundingBox().getMaxX();
    }

    private static Codeword detectCodeword(BitMatrix image, int minColumn, int maxColumn, boolean leftToRight, int startColumn, int imageRow, int minCodewordWidth, int maxCodewordWidth) {
        int endColumn;
        int[] moduleBitCount = PDF417ScanningDecoder.getModuleBitCount(image, minColumn, maxColumn, leftToRight, startColumn = PDF417ScanningDecoder.adjustCodewordStartColumn(image, minColumn, maxColumn, leftToRight, startColumn, imageRow), imageRow);
        if (moduleBitCount == null) {
            return null;
        }
        int codewordBitCount = MathUtils.sum(moduleBitCount);
        if (leftToRight) {
            endColumn = startColumn + codewordBitCount;
        } else {
            int i = 0;
            while (i < moduleBitCount.length / 2) {
                int tmpCount = moduleBitCount[i];
                moduleBitCount[i] = moduleBitCount[moduleBitCount.length - 1 - i];
                moduleBitCount[moduleBitCount.length - 1 - i] = tmpCount;
                ++i;
            }
            endColumn = startColumn;
            startColumn = endColumn - codewordBitCount;
        }
        if (!PDF417ScanningDecoder.checkCodewordSkew(codewordBitCount, minCodewordWidth, maxCodewordWidth)) {
            return null;
        }
        int decodedValue = PDF417CodewordDecoder.getDecodedValue(moduleBitCount);
        int codeword = PDF417Common.getCodeword(decodedValue);
        if (codeword == -1) {
            return null;
        }
        return new Codeword(startColumn, endColumn, PDF417ScanningDecoder.getCodewordBucketNumber(decodedValue), codeword);
    }

    private static int[] getModuleBitCount(BitMatrix image, int minColumn, int maxColumn, boolean leftToRight, int startColumn, int imageRow) {
        int imageColumn = startColumn;
        int[] moduleBitCount = new int[8];
        int moduleNumber = 0;
        int increment = leftToRight ? 1 : -1;
        boolean previousPixelValue = leftToRight;
        while ((leftToRight ? imageColumn < maxColumn : imageColumn >= minColumn) && moduleNumber < moduleBitCount.length) {
            if (image.get(imageColumn, imageRow) == previousPixelValue) {
                int n = moduleNumber;
                moduleBitCount[n] = moduleBitCount[n] + 1;
                imageColumn += increment;
                continue;
            }
            ++moduleNumber;
            boolean bl = previousPixelValue = !previousPixelValue;
        }
        if (moduleNumber == moduleBitCount.length || imageColumn == (leftToRight ? maxColumn : minColumn) && moduleNumber == moduleBitCount.length - 1) {
            return moduleBitCount;
        }
        return null;
    }

    private static int getNumberOfECCodeWords(int barcodeECLevel) {
        return 2 << barcodeECLevel;
    }

    /*
     * Unable to fully structure code
     */
    private static int adjustCodewordStartColumn(BitMatrix image, int minColumn, int maxColumn, boolean leftToRight, int codewordStartColumn, int imageRow) {
        correctedStartColumn = codewordStartColumn;
        increment = leftToRight != false ? -1 : 1;
        i = 0;
        ** GOTO lbl13
        {
            if (Math.abs(codewordStartColumn - correctedStartColumn) > 2) {
                return codewordStartColumn;
            }
            correctedStartColumn += increment;
            do {
                if ((leftToRight != false ? correctedStartColumn >= minColumn : correctedStartColumn < maxColumn) && leftToRight == image.get(correctedStartColumn, imageRow)) continue block0;
                increment = -increment;
                leftToRight = leftToRight == false;
                ++i;
lbl13:
                // 2 sources

            } while (i < 2);
        }
        return correctedStartColumn;
    }

    private static boolean checkCodewordSkew(int codewordSize, int minCodewordWidth, int maxCodewordWidth) {
        return minCodewordWidth - 2 <= codewordSize && codewordSize <= maxCodewordWidth + 2;
    }

    private static DecoderResult decodeCodewords(int[] codewords, int ecLevel, int[] erasures) throws FormatException, ChecksumException {
        if (codewords.length == 0) {
            throw FormatException.getFormatInstance();
        }
        int numECCodewords = 1 << ecLevel + 1;
        int correctedErrorsCount = PDF417ScanningDecoder.correctErrors(codewords, erasures, numECCodewords);
        PDF417ScanningDecoder.verifyCodewordCount(codewords, numECCodewords);
        DecoderResult decoderResult = DecodedBitStreamParser.decode(codewords, String.valueOf(ecLevel));
        decoderResult.setErrorsCorrected(correctedErrorsCount);
        decoderResult.setErasures(erasures.length);
        return decoderResult;
    }

    private static int correctErrors(int[] codewords, int[] erasures, int numECCodewords) throws ChecksumException {
        if (erasures != null && erasures.length > numECCodewords / 2 + 3 || numECCodewords < 0 || numECCodewords > 512) {
            throw ChecksumException.getChecksumInstance();
        }
        return errorCorrection.decode(codewords, numECCodewords, erasures);
    }

    private static void verifyCodewordCount(int[] codewords, int numECCodewords) throws FormatException {
        if (codewords.length < 4) {
            throw FormatException.getFormatInstance();
        }
        int numberOfCodewords = codewords[0];
        if (numberOfCodewords > codewords.length) {
            throw FormatException.getFormatInstance();
        }
        if (numberOfCodewords == 0) {
            if (numECCodewords < codewords.length) {
                codewords[0] = codewords.length - numECCodewords;
            } else {
                throw FormatException.getFormatInstance();
            }
        }
    }

    private static int[] getBitCountForCodeword(int codeword) {
        int[] result = new int[8];
        int previousValue = 0;
        int i = result.length - 1;
        while (true) {
            if ((codeword & 1) != previousValue) {
                previousValue = codeword & 1;
                if (--i < 0) break;
            }
            int n = i;
            result[n] = result[n] + 1;
            codeword >>= 1;
        }
        return result;
    }

    private static int getCodewordBucketNumber(int codeword) {
        return PDF417ScanningDecoder.getCodewordBucketNumber(PDF417ScanningDecoder.getBitCountForCodeword(codeword));
    }

    private static int getCodewordBucketNumber(int[] moduleBitCount) {
        return (moduleBitCount[0] - moduleBitCount[2] + moduleBitCount[4] - moduleBitCount[6] + 9) % 9;
    }

    public static String toString(BarcodeValue[][] barcodeMatrix) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Formatter formatter = new Formatter();){
            int row = 0;
            while (row < barcodeMatrix.length) {
                formatter.format("Row %2d: ", row);
                int column = 0;
                while (column < barcodeMatrix[row].length) {
                    BarcodeValue barcodeValue = barcodeMatrix[row][column];
                    if (barcodeValue.getValue().length == 0) {
                        formatter.format("        ", null);
                    } else {
                        formatter.format("%4d(%2d)", barcodeValue.getValue()[0], barcodeValue.getConfidence(barcodeValue.getValue()[0]));
                    }
                    ++column;
                }
                formatter.format("%n", new Object[0]);
                ++row;
            }
            return formatter.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

