/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.support.AbstractDispatcherServletInitializer;

public abstract class AbstractAnnotationConfigDispatcherServletInitializer
extends AbstractDispatcherServletInitializer {
    protected WebApplicationContext createRootApplicationContext() {
        Object[] rootConfigClasses = this.getRootConfigClasses();
        if (!ObjectUtils.isEmpty((Object[])rootConfigClasses)) {
            AnnotationConfigWebApplicationContext rootAppContext = new AnnotationConfigWebApplicationContext();
            rootAppContext.register((Class[])rootConfigClasses);
            return rootAppContext;
        }
        return null;
    }

    @Override
    protected WebApplicationContext createServletApplicationContext() {
        AnnotationConfigWebApplicationContext servletAppContext = new AnnotationConfigWebApplicationContext();
        Object[] servletConfigClasses = this.getServletConfigClasses();
        Assert.notEmpty((Object[])servletConfigClasses, (String)"getServletConfigClasses() did not return any configuration classes");
        servletAppContext.register((Class[])servletConfigClasses);
        return servletAppContext;
    }

    protected abstract Class<?>[] getRootConfigClasses();

    protected abstract Class<?>[] getServletConfigClasses();
}

