/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.MappedInterceptor;

public class InterceptorRegistration {
    private final HandlerInterceptor interceptor;
    private final List<String> includePatterns = new ArrayList<String>();
    private final List<String> excludePatterns = new ArrayList<String>();

    public InterceptorRegistration(HandlerInterceptor interceptor) {
        Assert.notNull((Object)interceptor, (String)"Interceptor is required");
        this.interceptor = interceptor;
    }

    public InterceptorRegistration addPathPatterns(String ... patterns) {
        this.includePatterns.addAll(Arrays.asList(patterns));
        return this;
    }

    public InterceptorRegistration excludePathPatterns(String ... patterns) {
        this.excludePatterns.addAll(Arrays.asList(patterns));
        return this;
    }

    protected Object getInterceptor() {
        if (this.includePatterns.isEmpty()) {
            return this.interceptor;
        }
        return new MappedInterceptor(InterceptorRegistration.toArray(this.includePatterns), InterceptorRegistration.toArray(this.excludePatterns), this.interceptor);
    }

    private static String[] toArray(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }
}

