/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.SubProtocolCapable;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;

public class DefaultHandshakeHandler
implements HandshakeHandler {
    protected Log logger = LogFactory.getLog(this.getClass());
    private static final boolean jettyWsPresent = ClassUtils.isPresent((String)"org.eclipse.jetty.websocket.server.WebSocketServerFactory", (ClassLoader)DefaultHandshakeHandler.class.getClassLoader());
    private static final boolean tomcatWsPresent = ClassUtils.isPresent((String)"org.apache.tomcat.websocket.server.WsHttpUpgradeHandler", (ClassLoader)DefaultHandshakeHandler.class.getClassLoader());
    private static final boolean glassFishWsPresent = ClassUtils.isPresent((String)"org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler", (ClassLoader)DefaultHandshakeHandler.class.getClassLoader());
    private final RequestUpgradeStrategy requestUpgradeStrategy;
    private final List<String> supportedProtocols = new ArrayList<String>();

    public DefaultHandshakeHandler() {
        this(DefaultHandshakeHandler.initRequestUpgradeStrategy());
    }

    private static RequestUpgradeStrategy initRequestUpgradeStrategy() {
        String className;
        if (jettyWsPresent) {
            className = "org.springframework.web.socket.server.jetty.JettyRequestUpgradeStrategy";
        } else if (tomcatWsPresent) {
            className = "org.springframework.web.socket.server.standard.TomcatRequestUpgradeStrategy";
        } else if (glassFishWsPresent) {
            className = "org.springframework.web.socket.server.standard.GlassFishRequestUpgradeStrategy";
        } else {
            throw new IllegalStateException("No suitable default RequestUpgradeStrategy found");
        }
        try {
            Class clazz = ClassUtils.forName((String)className, (ClassLoader)DefaultHandshakeHandler.class.getClassLoader());
            return (RequestUpgradeStrategy)clazz.newInstance();
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to instantiate RequestUpgradeStrategy: " + className, ex);
        }
    }

    public DefaultHandshakeHandler(RequestUpgradeStrategy requestUpgradeStrategy) {
        Assert.notNull((Object)requestUpgradeStrategy, (String)"RequestUpgradeStrategy must not be null");
        this.requestUpgradeStrategy = requestUpgradeStrategy;
    }

    public void setSupportedProtocols(String ... protocols) {
        this.supportedProtocols.clear();
        for (String protocol : protocols) {
            this.supportedProtocols.add(protocol.toLowerCase());
        }
    }

    public String[] getSupportedProtocols() {
        return this.supportedProtocols.toArray(new String[this.supportedProtocols.size()]);
    }

    @Override
    public final boolean doHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws HandshakeFailureException {
        WebSocketHttpHeaders headers = new WebSocketHttpHeaders(request.getHeaders());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Initiating handshake for " + request.getURI() + ", headers=" + (Object)((Object)headers)));
        }
        try {
            if (!HttpMethod.GET.equals((Object)request.getMethod())) {
                response.setStatusCode(HttpStatus.METHOD_NOT_ALLOWED);
                response.getHeaders().setAllow(Collections.singleton(HttpMethod.GET));
                this.logger.debug((Object)("Only HTTP GET is allowed, current method is " + request.getMethod()));
                return false;
            }
            if (!"WebSocket".equalsIgnoreCase(headers.getUpgrade())) {
                this.handleInvalidUpgradeHeader(request, response);
                return false;
            }
            if (!headers.getConnection().contains("Upgrade") && !headers.getConnection().contains("upgrade")) {
                this.handleInvalidConnectHeader(request, response);
                return false;
            }
            if (!this.isWebSocketVersionSupported(headers)) {
                this.handleWebSocketVersionNotSupported(request, response);
                return false;
            }
            if (!this.isValidOrigin(request)) {
                response.setStatusCode(HttpStatus.FORBIDDEN);
                return false;
            }
            String wsKey = headers.getSecWebSocketKey();
            if (wsKey == null) {
                this.logger.debug((Object)"Missing \"Sec-WebSocket-Key\" header");
                response.setStatusCode(HttpStatus.BAD_REQUEST);
                return false;
            }
        }
        catch (IOException ex) {
            throw new HandshakeFailureException("Response update failed during upgrade to WebSocket, uri=" + request.getURI(), ex);
        }
        String subProtocol = this.selectProtocol(headers.getSecWebSocketProtocol(), wsHandler);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Selected sub-protocol: '" + subProtocol + "'"));
        }
        List<WebSocketExtension> requested = headers.getSecWebSocketExtensions();
        List<WebSocketExtension> supported = this.requestUpgradeStrategy.getSupportedExtensions(request);
        List<WebSocketExtension> extensions = this.filterRequestedExtensions(request, requested, supported);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Upgrading request, sub-protocol=" + subProtocol + ", extensions=" + extensions));
        }
        this.requestUpgradeStrategy.upgrade(request, response, subProtocol, extensions, wsHandler, attributes);
        return true;
    }

    protected void handleInvalidUpgradeHeader(ServerHttpRequest request, ServerHttpResponse response) throws IOException {
        this.logger.debug((Object)("Invalid Upgrade header " + request.getHeaders().getUpgrade()));
        response.setStatusCode(HttpStatus.BAD_REQUEST);
        response.getBody().write("Can \"Upgrade\" only to \"WebSocket\".".getBytes("UTF-8"));
    }

    protected void handleInvalidConnectHeader(ServerHttpRequest request, ServerHttpResponse response) throws IOException {
        this.logger.debug((Object)("Invalid Connection header " + request.getHeaders().getConnection()));
        response.setStatusCode(HttpStatus.BAD_REQUEST);
        response.getBody().write("\"Connection\" must be \"upgrade\".".getBytes("UTF-8"));
    }

    protected boolean isWebSocketVersionSupported(WebSocketHttpHeaders httpHeaders) {
        String version = httpHeaders.getSecWebSocketVersion();
        Object[] supportedVersions = this.getSupportedVersions();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Requested version=" + version + ", supported=" + Arrays.toString(supportedVersions)));
        }
        for (Object supportedVersion : supportedVersions) {
            if (!((String)supportedVersion).trim().equals(version)) continue;
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Version " + version + " is not a supported WebSocket version"));
        }
        return false;
    }

    protected String[] getSupportedVersions() {
        return this.requestUpgradeStrategy.getSupportedVersions();
    }

    protected void handleWebSocketVersionNotSupported(ServerHttpRequest request, ServerHttpResponse response) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("WebSocket version not supported: " + request.getHeaders().get((Object)"Sec-WebSocket-Version")));
        }
        response.setStatusCode(HttpStatus.UPGRADE_REQUIRED);
        response.getHeaders().put("Sec-WebSocket-Version", Arrays.asList(StringUtils.arrayToCommaDelimitedString((Object[])this.getSupportedVersions())));
    }

    protected boolean isValidOrigin(ServerHttpRequest request) {
        return true;
    }

    protected String selectProtocol(List<String> requestedProtocols, WebSocketHandler webSocketHandler) {
        if (requestedProtocols != null) {
            List<String> handlerProtocols = this.determineHandlerSupportedProtocols(webSocketHandler);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Requested sub-protocol(s): " + requestedProtocols + ", WebSocketHandler supported sub-protocol(s): " + handlerProtocols + ", configured sub-protocol(s): " + this.supportedProtocols));
            }
            for (String protocol : requestedProtocols) {
                if (handlerProtocols.contains(protocol.toLowerCase())) {
                    return protocol;
                }
                if (!this.supportedProtocols.contains(protocol.toLowerCase())) continue;
                return protocol;
            }
        }
        return null;
    }

    protected final List<String> determineHandlerSupportedProtocols(WebSocketHandler handler) {
        WebSocketHandler lastHandler;
        List<String> subProtocols = null;
        if (handler instanceof SubProtocolCapable) {
            subProtocols = ((SubProtocolCapable)((Object)handler)).getSubProtocols();
        } else if (handler instanceof WebSocketHandlerDecorator && (lastHandler = ((WebSocketHandlerDecorator)handler).getLastHandler()) instanceof SubProtocolCapable) {
            subProtocols = ((SubProtocolCapable)((Object)lastHandler)).getSubProtocols();
        }
        return subProtocols != null ? subProtocols : Collections.emptyList();
    }

    protected List<WebSocketExtension> filterRequestedExtensions(ServerHttpRequest request, List<WebSocketExtension> requested, List<WebSocketExtension> supported) {
        if (requested != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Requested extension(s): " + requested + ", supported extension(s): " + supported));
        }
        return requested;
    }
}

