/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.config;

import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.simp.config.AbstractBrokerRegistration;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.util.Assert;

public class StompBrokerRelayRegistration
extends AbstractBrokerRegistration {
    private String relayHost = "127.0.0.1";
    private int relayPort = 61613;
    private String applicationLogin = "guest";
    private String applicationPasscode = "guest";
    private Long systemHeartbeatSendInterval;
    private Long systemHeartbeatReceiveInterval;
    private boolean autoStartup = true;

    public StompBrokerRelayRegistration(SubscribableChannel clientInboundChannel, MessageChannel clientOutboundChannel, String[] destinationPrefixes) {
        super(clientInboundChannel, clientOutboundChannel, destinationPrefixes);
    }

    public StompBrokerRelayRegistration setRelayHost(String relayHost) {
        Assert.hasText((String)relayHost, (String)"relayHost must not be empty");
        this.relayHost = relayHost;
        return this;
    }

    public StompBrokerRelayRegistration setRelayPort(int relayPort) {
        this.relayPort = relayPort;
        return this;
    }

    public StompBrokerRelayRegistration setApplicationLogin(String login) {
        Assert.hasText((String)login, (String)"applicationLogin must not be empty");
        this.applicationLogin = login;
        return this;
    }

    public StompBrokerRelayRegistration setApplicationPasscode(String passcode) {
        Assert.hasText((String)passcode, (String)"applicationPasscode must not be empty");
        this.applicationPasscode = passcode;
        return this;
    }

    public StompBrokerRelayRegistration setSystemHeartbeatSendInterval(long systemHeartbeatSendInterval) {
        this.systemHeartbeatSendInterval = systemHeartbeatSendInterval;
        return this;
    }

    public StompBrokerRelayRegistration setSystemHeartbeatReceiveInterval(long heartbeatReceiveInterval) {
        this.systemHeartbeatReceiveInterval = heartbeatReceiveInterval;
        return this;
    }

    public StompBrokerRelayRegistration setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
        return this;
    }

    @Override
    protected StompBrokerRelayMessageHandler getMessageHandler(SubscribableChannel brokerChannel) {
        StompBrokerRelayMessageHandler handler = new StompBrokerRelayMessageHandler(this.getClientInboundChannel(), this.getClientOutboundChannel(), brokerChannel, this.getDestinationPrefixes());
        handler.setRelayHost(this.relayHost);
        handler.setRelayPort(this.relayPort);
        handler.setSystemLogin(this.applicationLogin);
        handler.setSystemPasscode(this.applicationPasscode);
        if (this.systemHeartbeatSendInterval != null) {
            handler.setSystemHeartbeatSendInterval(this.systemHeartbeatSendInterval);
        }
        if (this.systemHeartbeatReceiveInterval != null) {
            handler.setSystemHeartbeatReceiveInterval(this.systemHeartbeatReceiveInterval);
        }
        handler.setAutoStartup(this.autoStartup);
        return handler;
    }
}

