/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp;

import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class SimpMessagingTemplate
extends AbstractMessageSendingTemplate<String>
implements SimpMessageSendingOperations {
    private final MessageChannel messageChannel;
    private String userDestinationPrefix = "/user/";
    private volatile long sendTimeout = -1L;

    public SimpMessagingTemplate(MessageChannel messageChannel) {
        Assert.notNull((Object)messageChannel, (String)"MessageChannel must not be null");
        this.messageChannel = messageChannel;
    }

    public void setUserDestinationPrefix(String prefix) {
        Assert.notNull((Object)prefix, (String)"UserDestinationPrefix must not be null");
        this.userDestinationPrefix = prefix;
    }

    public String getUserDestinationPrefix() {
        return this.userDestinationPrefix;
    }

    public MessageChannel getMessageChannel() {
        return this.messageChannel;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    @Override
    public void send(Message<?> message) {
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        String destination = headers.getDestination();
        destination = destination != null ? destination : (String)this.getRequiredDefaultDestination();
        this.doSend(destination, message);
    }

    @Override
    protected void doSend(String destination, Message<?> message) {
        boolean sent;
        Assert.notNull((Object)destination, (String)"Destination must not be null");
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        headers.setDestination(destination);
        headers.setMessageTypeIfNotSet(SimpMessageType.MESSAGE);
        message = MessageBuilder.withPayload(message.getPayload()).setHeaders(headers).build();
        long timeout = this.sendTimeout;
        boolean bl = sent = timeout >= 0L ? this.messageChannel.send(message, timeout) : this.messageChannel.send(message);
        if (!sent) {
            throw new MessageDeliveryException(message, "failed to send message to destination '" + destination + "' within timeout: " + timeout);
        }
    }

    @Override
    public void convertAndSendToUser(String user, String destination, Object payload) throws MessagingException {
        MessagePostProcessor postProcessor = null;
        this.convertAndSendToUser(user, destination, payload, postProcessor);
    }

    @Override
    public void convertAndSendToUser(String user, String destination, Object payload, Map<String, Object> headers) throws MessagingException {
        MessagePostProcessor postProcessor = null;
        this.convertAndSendToUser(user, destination, payload, headers, postProcessor);
    }

    @Override
    public void convertAndSendToUser(String user, String destination, Object payload, MessagePostProcessor postProcessor) throws MessagingException {
        Map<String, Object> headers = null;
        this.convertAndSendToUser(user, destination, payload, headers, postProcessor);
    }

    @Override
    public void convertAndSendToUser(String user, String destination, Object payload, Map<String, Object> headers, MessagePostProcessor postProcessor) throws MessagingException {
        Assert.notNull((Object)user, (String)"User must not be null");
        super.convertAndSend(this.userDestinationPrefix + user + destination, payload, headers, postProcessor);
    }
}

