/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.guava;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.guava.GuavaCache;
import org.springframework.util.Assert;

public class GuavaCacheManager
implements CacheManager,
DisposableBean {
    private final ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>(16);
    private boolean dynamic = true;
    private CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder();
    private CacheLoader<Object, Object> cacheLoader;

    public GuavaCacheManager() {
    }

    public GuavaCacheManager(String ... cacheNames) {
        this.setCacheNames(Arrays.asList(cacheNames));
    }

    public void setCacheNames(Collection<String> cacheNames) {
        if (cacheNames != null) {
            for (String name : cacheNames) {
                this.cacheMap.put(name, this.createGuavaCache(name));
            }
            this.dynamic = false;
        }
    }

    public void setCacheBuilder(CacheBuilder<Object, Object> cacheBuilder) {
        Assert.notNull(cacheBuilder, (String)"CacheBuilder must not be null");
        this.cacheBuilder = cacheBuilder;
    }

    public void setCacheBuilderSpec(CacheBuilderSpec cacheBuilderSpec) {
        this.cacheBuilder = CacheBuilder.from((CacheBuilderSpec)cacheBuilderSpec);
    }

    public void setCacheSpecification(String cacheSpecification) {
        this.cacheBuilder = CacheBuilder.from((String)cacheSpecification);
    }

    public void setCacheLoader(CacheLoader<Object, Object> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache(String name) {
        Cache cache = (Cache)this.cacheMap.get(name);
        if (cache == null && this.dynamic) {
            ConcurrentMap<String, Cache> concurrentMap = this.cacheMap;
            synchronized (concurrentMap) {
                cache = (Cache)this.cacheMap.get(name);
                if (cache == null) {
                    cache = this.createGuavaCache(name);
                    this.cacheMap.put(name, cache);
                }
            }
        }
        return cache;
    }

    protected Cache createGuavaCache(String name) {
        return new GuavaCache(name, this.createNativeGuavaCache(name));
    }

    protected com.google.common.cache.Cache<Object, Object> createNativeGuavaCache(String name) {
        if (this.cacheLoader != null) {
            return this.cacheBuilder.build(this.cacheLoader);
        }
        return this.cacheBuilder.build();
    }

    public void destroy() {
        for (Cache cache : this.cacheMap.values()) {
        }
    }
}

