/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.pdf417.decoder.BoundingBox;
import com.google.zxing.pdf417.decoder.Codeword;
import java.util.Formatter;

class DetectionResultColumn {
    private static final int MAX_NEARBY_DISTANCE = 5;
    private final BoundingBox boundingBox;
    private final Codeword[] codewords;

    DetectionResultColumn(BoundingBox boundingBox) {
        this.boundingBox = new BoundingBox(boundingBox);
        this.codewords = new Codeword[boundingBox.getMaxY() - boundingBox.getMinY() + 1];
    }

    final Codeword getCodewordNearby(int imageRow) {
        Codeword codeword = this.getCodeword(imageRow);
        if (codeword != null) {
            return codeword;
        }
        int i = 1;
        while (i < 5) {
            int nearImageRow = this.imageRowToCodewordIndex(imageRow) - i;
            if (nearImageRow >= 0 && (codeword = this.codewords[nearImageRow]) != null) {
                return codeword;
            }
            nearImageRow = this.imageRowToCodewordIndex(imageRow) + i;
            if (nearImageRow < this.codewords.length && (codeword = this.codewords[nearImageRow]) != null) {
                return codeword;
            }
            ++i;
        }
        return null;
    }

    final int imageRowToCodewordIndex(int imageRow) {
        return imageRow - this.boundingBox.getMinY();
    }

    final void setCodeword(int imageRow, Codeword codeword) {
        this.codewords[this.imageRowToCodewordIndex((int)imageRow)] = codeword;
    }

    final Codeword getCodeword(int imageRow) {
        return this.codewords[this.imageRowToCodewordIndex(imageRow)];
    }

    final BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    final Codeword[] getCodewords() {
        return this.codewords;
    }

    public String toString() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Formatter formatter = new Formatter();){
            int row = 0;
            Codeword[] codewordArray = this.codewords;
            int n = this.codewords.length;
            int n2 = 0;
            while (n2 < n) {
                Codeword codeword = codewordArray[n2];
                if (codeword == null) {
                    formatter.format("%3d:    |   %n", row++);
                } else {
                    formatter.format("%3d: %3d|%3d%n", row++, codeword.getRowNumber(), codeword.getValue());
                }
                ++n2;
            }
            return formatter.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

