/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class Code39Reader
extends OneDReader {
    static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";
    static final int[] CHARACTER_ENCODINGS = new int[]{52, 289, 97, 352, 49, 304, 112, 37, 292, 100, 265, 73, 328, 25, 280, 88, 13, 268, 76, 28, 259, 67, 322, 19, 274, 82, 7, 262, 70, 22, 385, 193, 448, 145, 400, 208, 133, 388, 196, 168, 162, 138, 42};
    static final int ASTERISK_ENCODING = 148;
    private final boolean usingCheckDigit;
    private final boolean extendedMode;
    private final StringBuilder decodeRowResult;
    private final int[] counters;

    public Code39Reader() {
        this(false);
    }

    public Code39Reader(boolean usingCheckDigit) {
        this(usingCheckDigit, false);
    }

    public Code39Reader(boolean usingCheckDigit, boolean extendedMode) {
        this.usingCheckDigit = usingCheckDigit;
        this.extendedMode = extendedMode;
        this.decodeRowResult = new StringBuilder(20);
        this.counters = new int[9];
    }

    @Override
    public Result decodeRow(int rowNumber, BitArray row, Map<DecodeHintType, ?> hints) throws NotFoundException, ChecksumException, FormatException {
        int counter;
        int n;
        int n2;
        int[] nArray;
        int lastStart;
        char decodedChar;
        int[] theCounters = this.counters;
        Arrays.fill(theCounters, 0);
        StringBuilder result = this.decodeRowResult;
        result.setLength(0);
        int[] start = Code39Reader.findAsteriskPattern(row, theCounters);
        int nextStart = row.getNextSet(start[1]);
        int end = row.getSize();
        do {
            Code39Reader.recordPattern(row, nextStart, theCounters);
            int pattern = Code39Reader.toNarrowWidePattern(theCounters);
            if (pattern < 0) {
                throw NotFoundException.getNotFoundInstance();
            }
            decodedChar = Code39Reader.patternToChar(pattern);
            result.append(decodedChar);
            lastStart = nextStart;
            nArray = theCounters;
            n2 = theCounters.length;
            n = 0;
            while (n < n2) {
                counter = nArray[n];
                nextStart += counter;
                ++n;
            }
            nextStart = row.getNextSet(nextStart);
        } while (decodedChar != '*');
        result.setLength(result.length() - 1);
        int lastPatternSize = 0;
        nArray = theCounters;
        n2 = theCounters.length;
        n = 0;
        while (n < n2) {
            counter = nArray[n];
            lastPatternSize += counter;
            ++n;
        }
        int whiteSpaceAfterEnd = nextStart - lastStart - lastPatternSize;
        if (nextStart != end && whiteSpaceAfterEnd * 2 < lastPatternSize) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (this.usingCheckDigit) {
            int max = result.length() - 1;
            int total = 0;
            int i = 0;
            while (i < max) {
                total += ALPHABET_STRING.indexOf(this.decodeRowResult.charAt(i));
                ++i;
            }
            if (result.charAt(max) != ALPHABET_STRING.charAt(total % 43)) {
                throw ChecksumException.getChecksumInstance();
            }
            result.setLength(max);
        }
        if (result.length() == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        String resultString = this.extendedMode ? Code39Reader.decodeExtended(result) : result.toString();
        float left = (float)(start[1] + start[0]) / 2.0f;
        float right = (float)lastStart + (float)lastPatternSize / 2.0f;
        return new Result(resultString, null, new ResultPoint[]{new ResultPoint(left, rowNumber), new ResultPoint(right, rowNumber)}, BarcodeFormat.CODE_39);
    }

    private static int[] findAsteriskPattern(BitArray row, int[] counters) throws NotFoundException {
        int width = row.getSize();
        int rowOffset = row.getNextSet(0);
        int counterPosition = 0;
        int patternStart = rowOffset;
        boolean isWhite = false;
        int patternLength = counters.length;
        int i = rowOffset;
        while (i < width) {
            if (row.get(i) != isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
            } else {
                if (counterPosition == patternLength - 1) {
                    if (Code39Reader.toNarrowWidePattern(counters) == 148 && row.isRange(Math.max(0, patternStart - (i - patternStart) / 2), patternStart, false)) {
                        return new int[]{patternStart, i};
                    }
                    patternStart += counters[0] + counters[1];
                    System.arraycopy(counters, 2, counters, 0, counterPosition - 1);
                    counters[counterPosition - 1] = 0;
                    counters[counterPosition] = 0;
                    --counterPosition;
                } else {
                    ++counterPosition;
                }
                counters[counterPosition] = 1;
                isWhite = !isWhite;
            }
            ++i;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toNarrowWidePattern(int[] counters) {
        int wideCounters;
        int numCounters = counters.length;
        int maxNarrowCounter = 0;
        do {
            int minCounter = Integer.MAX_VALUE;
            int[] nArray = counters;
            int n = counters.length;
            int n2 = 0;
            while (n2 < n) {
                int counter = nArray[n2];
                if (counter < minCounter && counter > maxNarrowCounter) {
                    minCounter = counter;
                }
                ++n2;
            }
            maxNarrowCounter = minCounter;
            wideCounters = 0;
            int totalWideCountersWidth = 0;
            int pattern = 0;
            int i = 0;
            while (i < numCounters) {
                int counter = counters[i];
                if (counter > maxNarrowCounter) {
                    pattern |= 1 << numCounters - 1 - i;
                    ++wideCounters;
                    totalWideCountersWidth += counter;
                }
                ++i;
            }
            if (wideCounters != 3) continue;
            i = 0;
            while (i < numCounters && wideCounters > 0) {
                int counter = counters[i];
                if (counter > maxNarrowCounter) {
                    --wideCounters;
                    if (counter * 2 >= totalWideCountersWidth) {
                        return -1;
                    }
                }
                ++i;
            }
            return pattern;
        } while (wideCounters > 3);
        return -1;
    }

    private static char patternToChar(int pattern) throws NotFoundException {
        int i = 0;
        while (i < CHARACTER_ENCODINGS.length) {
            if (CHARACTER_ENCODINGS[i] == pattern) {
                return ALPHABET_STRING.charAt(i);
            }
            ++i;
        }
        if (pattern == 148) {
            return '*';
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static String decodeExtended(CharSequence encoded) throws FormatException {
        int length = encoded.length();
        StringBuilder decoded = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            char c = encoded.charAt(i);
            if (c == '+' || c == '$' || c == '%' || c == '/') {
                char next = encoded.charAt(i + 1);
                int decodedChar = 0;
                switch (c) {
                    case '+': {
                        if (next >= 'A' && next <= 'Z') {
                            decodedChar = (char)(next + 32);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '$': {
                        if (next >= 'A' && next <= 'Z') {
                            decodedChar = (char)(next - 64);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '%': {
                        if (next >= 'A' && next <= 'E') {
                            decodedChar = (char)(next - 38);
                            break;
                        }
                        if (next >= 'F' && next <= 'J') {
                            decodedChar = (char)(next - 11);
                            break;
                        }
                        if (next >= 'K' && next <= 'O') {
                            decodedChar = (char)(next + 16);
                            break;
                        }
                        if (next >= 'P' && next <= 'T') {
                            decodedChar = (char)(next + 43);
                            break;
                        }
                        if (next == 'U') {
                            decodedChar = 0;
                            break;
                        }
                        if (next == 'V') {
                            decodedChar = 64;
                            break;
                        }
                        if (next == 'W') {
                            decodedChar = 96;
                            break;
                        }
                        if (next == 'X' || next == 'Y' || next == 'Z') {
                            decodedChar = 127;
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '/': {
                        if (next >= 'A' && next <= 'O') {
                            decodedChar = (char)(next - 32);
                            break;
                        }
                        if (next == 'Z') {
                            decodedChar = 58;
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                }
                decoded.append((char)decodedChar);
                ++i;
            } else {
                decoded.append(c);
            }
            ++i;
        }
        return decoded.toString();
    }
}

